@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form method="POST" action="{{ route('guides.update', $guide->id_G) }}">
                        @csrf
                        @method('PUT')

                        <input type="hidden" name="id_type" value="{{ $guide->id_type }}">

                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">تعديل الدليل : {{ $guide->titre_G }}</h2>
                                <div class="stroke-shape"></div>
                            </div>

                            <div class="block-card-body">

                                <div class="form-group">
                                    <label>العنوان <span class="text-danger">*</span></label>
                                    <input type="text" name="titre_G" class="form-control" value="{{ old('titre_G', $guide->titre_G) }}" required>
                                </div>

                                <div class="form-group">
                                    <label>الترتيب <span class="text-danger">*</span></label>
                                    <input type="number" name="ordre" class="form-control" value="{{ old('ordre', $guide->ordre) }}" required>
                                </div>

                                <div class="form-group">
                                    <label>الدليل الأب (اختياري)</label>
                                    <select name="id_parent" class="form-control">
                                        <option value="">لا يوجد (دليل رئيسي)</option>
                                        @foreach($parentGuides as $parent)
                                            <option value="{{ $parent['id_G'] }}" {{ old('id_parent', $guide->id_parent) == $parent['id_G'] ? 'selected' : '' }}>
                                                {{ $parent['titre_G'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            <div class="block-card-footer mt-3 mb-3 text-center">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-save mr-1"></i> حفظ
                                </button>
                                <a href="{{ route('guides.index', $guide->id_type) }}" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-times mr-1"></i> إلغاء
                                </a>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
